<?php

namespace Convoworks\Luchianenco\OAuth2\Client\Provider;

use Convoworks\League\OAuth2\Client\Provider\AbstractProvider;
use Convoworks\League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use Convoworks\League\OAuth2\Client\Provider\ResourceOwnerInterface;
use Convoworks\League\OAuth2\Client\Token\AccessToken;
use Convoworks\Luchianenco\OAuth2\Client\Exception\AmazonIdentityProviderException;
use Psr\Http\Message\ResponseInterface;
class Amazon extends AbstractProvider
{
    /**
     * Returns the base URL for authorizing a client.
     *
     * @return string
     */
    public function getBaseAuthorizationUrl()
    {
        return 'https://www.amazon.com/ap/oa';
    }
    /**
     * Returns the base URL for requesting an access token.
     *
     * @param array $params
     * @return string
     */
    public function getBaseAccessTokenUrl(array $params)
    {
        return 'https://api.amazon.com/auth/o2/token';
    }
    /**
     * Returns the URL for requesting the resource owner's details.
     *
     * @param AccessToken $token
     * @return string
     */
    public function getResourceOwnerDetailsUrl(AccessToken $token)
    {
        return 'https://api.amazon.com/user/profile?' . \http_build_query(['access_token' => $token->getToken()]);
    }
    /**
     * Returns the default scopes used by this provider.
     *
     * @return array
     */
    protected function getDefaultScopes()
    {
        return ['profile'];
    }
    /**
     * Checks a provider response for errors.
     *
     * @throws IdentityProviderException
     * @param  ResponseInterface $response
     * @param  array|string $data Parsed response data
     * @return void
     */
    protected function checkResponse(ResponseInterface $response, $data)
    {
        if (!empty($data['error'])) {
            throw new AmazonIdentityProviderException($data['error'] ?: $response->getReasonPhrase(), $response->getStatusCode(), $response);
        }
    }
    /**
     * Generates a resource owner object from a successful resource owner
     * details request.
     *
     * @param  array $response
     * @param  AccessToken $token
     * @return ResourceOwnerInterface
     */
    protected function createResourceOwner(array $response, AccessToken $token)
    {
        return new AmazonResourceOwner($response);
    }
}
