<?php

namespace Convo\Wp\Providers;

use Convo\Wp\PackageLoader;
use Convo\Wp\DI\ServiceContainerFactory;
use Psr\Container\ContainerInterface;
use Psr\Log\LoggerInterface;
class ConvoWPPlugin
{
    private static $_packagesLoaded = \false;
    /**
     * @var \Psr\Container\ContainerInterface
     */
    private static $_publicDi;
    /**
     * @var \Psr\Container\ContainerInterface
     */
    private static $_adminDi;
    private static $_logged = \false;
    /**
     * Initialize the plugin
     *
     * @return void
     */
    public function init()
    {
        // hooks
        add_action('init', [new \Convo\Wp\Providers\HooksRegistration(), 'register']);
        // Register routes
        add_action('init', [new \Convo\Wp\Providers\RouteRegistration(), 'register']);
        // Add assets
        add_action('admin_init', [new \Convo\Wp\Providers\AssetsProvider(), 'init']);
        // shortcodes
        add_action('init', [new \Convo\Wp\Providers\ShortcodeRegistration(), 'register']);
        // Initialize upgrades to the db
        add_action('admin_init', [new \Convo\Wp\Providers\UpgradesProvider(), 'run']);
    }
    /**
     * Triggered when installing plugin
     */
    public function install()
    {
        $installer = new \Convo\Wp\Providers\PluginInstaller();
        $installer->run();
    }
    /**
     * Add some notices to the admin screens
     *
     * @return void
     */
    public function initNotices()
    {
    }
    /**
     * @return ContainerInterface
     */
    public static function getPublicDiContainer()
    {
        if (!isset(self::$_publicDi)) {
            // if (isset(self::$_adminDi)) {
            //     error_log('WARNING: Admin DI already created');
            // }
            // Build the Symfony container using the ServiceContainerFactory
            self::$_publicDi = ServiceContainerFactory::createPublicContainer();
        }
        return self::$_publicDi;
    }
    /**
     * @return ContainerInterface
     */
    public static function getAdminDiContainer()
    {
        if (!isset(self::$_adminDi)) {
            // if (isset(self::$_publicDi)) {
            //     error_log('WARNING: Public DI already created');
            // }
            // Build the Symfony container using the ServiceContainerFactory
            self::$_adminDi = ServiceContainerFactory::createAdminContainer();
        }
        return self::$_adminDi;
    }
    public static function getCurrentDiContainer()
    {
        if (self::isAdminRequest()) {
            return self::getAdminDiContainer();
        }
        return self::getPublicDiContainer();
    }
    public static function isAdminRequest()
    {
        if (is_admin() || is_customize_preview()) {
            return \true;
        }
        $uri = $_SERVER['REQUEST_URI'];
        if (\stripos($uri, 'convo/v1') !== \false) {
            if (\stripos($uri, 'convo/v1/public') === \false && \stripos($uri, 'convo/v1/media') === \false) {
                return \true;
            }
        }
        return \false;
    }
    /**
     * @return LoggerInterface $logger
     */
    public static function getLogger()
    {
        return self::getCurrentDiContainer()->get('logger');
    }
    /**
     * @param LoggerInterface $logger
     */
    public static function logRequest($logger)
    {
        if (self::$_logged) {
            return;
        }
        self::$_logged = \true;
        $logger->info('============================================================');
        if (isset($_SERVER['REQUEST_SCHEME']) && isset($_SERVER['HTTP_HOST'])) {
            $logger->info($_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
        }
        if (isset($_SERVER['CONTENT_TYPE'])) {
            $logger->info('Content-Type: ' . $_SERVER['CONTENT_TYPE']);
        }
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $logger->info('User-Agent: ' . $_SERVER['HTTP_USER_AGENT']);
        }
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $logger->info('IP: ' . $_SERVER['HTTP_X_FORWARDED_FOR']);
        } elseif (isset($_SERVER['REMOTE_ADDR'])) {
            $logger->info('IP: ' . $_SERVER['REMOTE_ADDR']);
        }
        if (isset($_SERVER['REQUEST_METHOD'])) {
            $logger->info('Method: ' . $_SERVER['REQUEST_METHOD']);
        }
        $logger->info('============================================================');
    }
    public static function loadPackages($container)
    {
        if (!self::$_packagesLoaded) {
            $loader = new PackageLoader($container->get('logger'), $container, $container->get('packageProviderFactory'));
            $loader->load();
        }
        self::$_packagesLoaded = \true;
    }
}
