### WP Hook Processor

Register a Convoworks workflow as a callback for a WordPress **action** or **filter** hook.

### When to use

Use **WP Hook Processor** when you want Convoworks to:

- Attach logic to a specific WordPress hook (action or filter).
- Run a Convoworks **OK flow** whenever that hook is fired.
- Optionally **modify the filter return value** using **WP Filter Result** or return a **WP Hook Error**.

This is the entry point for integrating Convoworks services into the standard WordPress hooks system.

### Properties

#### Hook type (`hookType`)

Select whether this processor handles an **Action** or a **Filter**.

- **Action** – use when the hook only triggers side effects (no meaningful return value).
- **Filter** – use when the hook returns a value that you may want to modify.

#### Hook (`hook`)

Name of the WordPress hook to register.

- Example actions: `init`, `wp_head`, `save_post`.
- Example filters: `the_content`, `the_title`, `pre_get_posts`.

#### Priority (`priority`)

String that evaluates to the **priority** at which your callback is attached.

- Lower numbers run **earlier**; default is `10`.
- Example: `"5"` for early, `"20"` for later.

#### Accepted arguments (`accepted_args`)

String that evaluates to the number of arguments your callback receives from WordPress.

- Default: `"1"`.
- Must match the number of parameters the hook actually passes.
- Those arguments are available through the request:
  - `${request.getArguments()}` – all arguments as an array.
  - `${request.getArgument(0)}` – first argument, etc.

#### OK flow (`ok`)

Sequence of child elements that will run when the hook is triggered.

- Can contain any conversation elements (Echo, rules, other logic, etc.).
- For **filters**, use **WP Filter Result** (or **WP Hook Error**) at the end of the flow to return a value.

### Runtime behavior

- At configuration time, this processor exposes its hook information (`hook_type`, `hook`, `priority`, `accepted_args`) so the platform can call the appropriate `add_action()` / `add_filter()`.
- At runtime:
  - The `filter()` method:
    - Checks whether the incoming request is a `WpHooksCommandRequest`.
    - If the hook name matches, it sets `hook_name` in the filter result so the processor is considered a match.
  - The `process()` method:
    - Runs all elements in the **OK flow** in order, calling `read()` on each.
    - Any terminating element (e.g. **WP Filter Result**, **WP Hook Error**, **Exit**) can stop processing early.

### Hook request helpers

Inside the OK flow, you can access hook data via the request object:

- `${request.getHook()}` – hook name.
- `${request.getArguments()}` – array of hook arguments.
- `${request.getArgument(0)}` – first argument, etc.

### Example

Register a filter on `the_content` that appends a note to post content:

- **Hook type**: `Filter`
- **Hook**: `the_content`
- **Accepted arguments**: `1`
- In **OK flow**:
  - Add **WP Filter Result** with:
    - **Return value**: `${request.getArgument(0) ~ "<p>Generated by Convoworks.</p>"}`

Whenever WordPress applies `the_content`, Convoworks will append the extra paragraph.

### Tips

- Make sure **Accepted arguments** matches the actual hook signature to avoid missing data or errors.
- For **filters**, always finish the flow with **WP Filter Result** (or **WP Hook Error**) so WordPress receives a clear result.
- For **actions**, you typically do not need to return anything; just run side effects in the OK flow.
- Keep hook workflows lightweight – WordPress hooks can fire often, so expensive logic may impact performance.


