<?php

declare (strict_types=1);
namespace Convo\Wp\Pckg\WpCore;

use Convo\Core\Factory\AbstractPackageDefinition;
use Convo\Core\Factory\IComponentFactory;
use Convo\Core\Workflow\IRunnableBlock;
use Convo\Core\Expression\ExpressionFunction;
use Convo\Core\Factory\ComponentDefinition;
use Convo\Pckg\Core\CorePackageDefinition;
use Convo\Wp\AdminUserDataProvider;
class WpPostsPackageDefinition extends AbstractPackageDefinition
{
    public const NAMESPACE = 'convo-wp-core';
    /**
     * @var \Convo\Core\Factory\PackageProviderFactory
     */
    private $_packageProviderFactory;
    /**
     * @var AdminUserDataProvider
     */
    private $_adminUserDataProvider;
    private $_wpdb;
    public function __construct(\Psr\Log\LoggerInterface $logger, \Convo\Core\Factory\PackageProviderFactory $packageProviderFactory, AdminUserDataProvider $adminUserDataProvider)
    {
        global $wpdb;
        $this->_packageProviderFactory = $packageProviderFactory;
        $this->_adminUserDataProvider = $adminUserDataProvider;
        $this->_wpdb = $wpdb;
        parent::__construct($logger, self::NAMESPACE, __DIR__);
        $this->registerTemplate(__DIR__ . '/searchable-player.template.json');
        // $this->registerTemplate(__DIR__ . '/loop-player.template.json');
        // $this->registerTemplate(__DIR__ . '/loop-example.template.json');
        // $this->registerTemplate(__DIR__ . '/loop-list.template.json');
    }
    protected function _initIntents()
    {
        return $this->_loadIntents(__DIR__ . '/system-intents.json');
    }
    public function getFunctions()
    {
        $functions = [];
        // https://developer.wordpress.org/reference/functions/get_the_excerpt/
        $functions[] = ExpressionFunction::fromEvaluator('get_the_excerpt', function ($args, $post = null) {
            return get_the_excerpt($post);
        });
        // https://developer.wordpress.org/reference/functions/get_the_post_thumbnail_url/
        $functions[] = ExpressionFunction::fromEvaluator('get_the_post_thumbnail_url', function ($args, $post = null, $size = null) {
            return get_the_post_thumbnail_url($post, $size);
        });
        // https://developer.wordpress.org/reference/functions/get_the_title/
        $functions[] = ExpressionFunction::fromEvaluator('get_the_title', function ($args, $post = null) {
            return get_the_title($post);
        });
        // https://developer.wordpress.org/reference/functions/get_the_content/
        $functions[] = ExpressionFunction::fromEvaluator('get_the_content', function ($args, $more_link_text = null, $strip_teaser = \false, $post = null) {
            return get_the_content($more_link_text, $strip_teaser, $post);
        });
        // https://developer.wordpress.org/reference/functions/get_the_author/
        $functions[] = ExpressionFunction::fromEvaluator('get_the_author', function ($args) {
            return get_the_author();
        });
        // https://developer.wordpress.org/reference/functions/wp_strip_all_tags/
        $functions[] = ExpressionFunction::fromEvaluator('wp_strip_all_tags', function ($args, $string, $removeBreaks = null) {
            return wp_strip_all_tags($string, $removeBreaks);
        });
        // https://developer.wordpress.org/reference/functions/wp_trim_words/
        $functions[] = ExpressionFunction::fromEvaluator('wp_trim_words', function ($args, $text, $numWords = 55, $more = null) {
            return wp_trim_words($text, $numWords, $more);
        });
        // https://developer.wordpress.org/reference/functions/get_post_meta/
        $functions[] = ExpressionFunction::fromEvaluator('get_post_meta', function ($args, $post_id, $key = '', $single = \false) {
            return get_post_meta($post_id, $key, $single);
        });
        // https://developer.wordpress.org/reference/functions/wp_get_attachment_metadata/
        $functions[] = ExpressionFunction::fromEvaluator('wp_get_attachment_metadata', function ($args, $attachment_id = 0, $unfiltered = \false) {
            return wp_get_attachment_metadata($attachment_id, $unfiltered);
        });
        // https://developer.wordpress.org/reference/functions/wp_get_attachment_url/
        $functions[] = ExpressionFunction::fromEvaluator('wp_get_attachment_url', function ($args, $attachment_id = 0) {
            return wp_get_attachment_url($attachment_id);
        });
        // https://developer.wordpress.org/reference/functions/wp_get_attachment_image_url/
        $functions[] = ExpressionFunction::fromEvaluator('wp_get_attachment_image_url', function ($args, $attachment_id, $size = 'thumbnail', $icon = \false) {
            return wp_get_attachment_image_url($attachment_id, $size, $icon);
        });
        // https://developer.wordpress.org/reference/functions/wp_insert_attachment/
        $functions[] = ExpressionFunction::fromEvaluator('wp_insert_attachment', function ($args, $postarr, $file, $parent_post_id = 0, $wp_error = \false) {
            return wp_insert_attachment($postarr, $file, $parent_post_id, $wp_error);
        });
        // https://developer.wordpress.org/reference/functions/wp_update_attachment_metadata/
        $functions[] = ExpressionFunction::fromEvaluator('wp_update_attachment_metadata', function ($args, $post_id, $data) {
            return wp_update_attachment_metadata($post_id, $data);
        });
        // https://developer.wordpress.org/reference/functions/wp_delete_attachment/
        $functions[] = ExpressionFunction::fromEvaluator('wp_delete_attachment', function ($args, $post_id, $force_delete = \false) {
            return wp_delete_attachment($post_id, $force_delete);
        });
        // https://developer.wordpress.org/reference/functions/has_post_thumbnail/
        $functions[] = ExpressionFunction::fromEvaluator('has_post_thumbnail', function ($args, $post = null) {
            return has_post_thumbnail($post);
        });
        // https://developer.wordpress.org/reference/functions/wp_read_image_metadata/
        $functions[] = ExpressionFunction::fromEvaluator('wp_read_image_metadata', function ($args, $file) {
            return wp_read_image_metadata($file);
        });
        // https://developer.wordpress.org/reference/functions/get_post/
        $functions[] = ExpressionFunction::fromEvaluator('get_post', function ($args, $post = 0, $output = OBJECT, $filter = 'raw') {
            return get_post($post, $output, $filter);
        });
        // https://developer.wordpress.org/reference/functions/wp_count_posts/
        $functions[] = ExpressionFunction::fromEvaluator('wp_count_posts', function ($args, $type = 'post', $perm = '') {
            return wp_count_posts($type, $perm);
        });
        // https://developer.wordpress.org/reference/functions/get_user_by/
        $functions[] = ExpressionFunction::fromEvaluator('get_user_by', function ($args, $field = 'ID', $value = 0) {
            return get_user_by($field, $value);
        });
        // https://developer.wordpress.org/reference/functions/get_user_meta/
        $functions[] = ExpressionFunction::fromEvaluator('get_user_meta', function ($args, $user_id, $key = '', $single = \false) {
            return get_user_meta($user_id, $key, $single);
        });
        // https://developer.wordpress.org/reference/functions/wp_timezone_string/
        $functions[] = ExpressionFunction::fromEvaluator('wp_timezone_string', function ($args) {
            return wp_timezone_string();
        });
        // https://developer.wordpress.org/reference/functions/get_option/
        $functions[] = ExpressionFunction::fromEvaluator('get_option', function ($args, $name, $default = null) {
            return get_option($name, $default);
        });
        // https://developer.wordpress.org/reference/functions/update_option/
        $functions[] = ExpressionFunction::fromEvaluator('update_option', function ($args, $option, $value, $autoload = null) {
            return update_option($option, $value, $autoload);
        });
        // https://developer.wordpress.org/reference/functions/delete_option/
        $functions[] = ExpressionFunction::fromEvaluator('delete_option', function ($args, $option) {
            return delete_option($option);
        });
        // https://developer.wordpress.org/reference/functions/wp_get_current_user/
        $functions[] = ExpressionFunction::fromEvaluator('wp_get_current_user', function ($args) {
            return wp_get_current_user();
        });
        // https://developer.wordpress.org/reference/functions/wp_delete_post/
        $functions[] = ExpressionFunction::fromEvaluator('wp_delete_post', function ($args, $postid, $force = \false) {
            return wp_delete_post($postid, $force);
        });
        // https://developer.wordpress.org/reference/functions/wp_trash_post/
        $functions[] = ExpressionFunction::fromEvaluator('wp_trash_post', function ($args, $postid) {
            return wp_trash_post($postid);
        });
        // https://developer.wordpress.org/reference/functions/wptexturize/
        $functions[] = ExpressionFunction::fromEvaluator('wptexturize', function ($args, $text, $reset = \false) {
            return wptexturize($text, $reset);
        });
        // https://developer.wordpress.org/reference/functions/wpautop/
        $functions[] = ExpressionFunction::fromEvaluator('wpautop', function ($args, $text, $br = \true) {
            return wpautop($text, $br);
        });
        // https://developer.wordpress.org/reference/functions/get_permalink/
        $functions[] = ExpressionFunction::fromEvaluator('get_permalink', function ($args, $post = 0, $leavename = \false) {
            return get_permalink($post, $leavename);
        });
        // https://developer.wordpress.org/reference/functions/get_template_directory_uri/
        $functions[] = ExpressionFunction::fromEvaluator('get_template_directory_uri', function ($args) {
            return get_template_directory_uri();
        });
        // https://developer.wordpress.org/reference/functions/get_current_user_id/
        $functions[] = ExpressionFunction::fromEvaluator('get_current_user_id', function ($args) {
            return get_current_user_id();
        });
        // https://developer.wordpress.org/reference/functions/current_user_can/
        $functions[] = ExpressionFunction::fromEvaluator('current_user_can', function ($args, $capability, $args2 = null) {
            return current_user_can($capability, $args2);
        });
        // https://developer.wordpress.org/reference/functions/wp_mail/
        $functions[] = ExpressionFunction::fromEvaluator('wp_mail', function ($args, $to, $subject, $message, $headers = '', $attachments = []) {
            return wp_mail($to, $subject, $message, $headers, $attachments);
        });
        // https://developer.wordpress.org/reference/functions/get_site_url/
        $functions[] = ExpressionFunction::fromEvaluator('get_site_url', function ($args, $blogId = null, $path = '', $scheme = null) {
            return get_site_url($blogId, $path, $scheme);
        });
        // https://developer.wordpress.org/reference/functions/get_posts/
        $functions[] = ExpressionFunction::fromEvaluator('get_posts', function ($args, $postArgs = null) {
            return get_posts($postArgs);
        });
        // https://developer.wordpress.org/reference/functions/wp_insert_post/
        $functions[] = ExpressionFunction::fromEvaluator('wp_insert_post', function ($args, $postarr, $wp_error = \false) {
            return wp_insert_post($postarr, $wp_error);
        });
        // https://developer.wordpress.org/reference/functions/update_post_meta/
        $functions[] = ExpressionFunction::fromEvaluator('update_post_meta', function ($args, $post_id, $meta_key, $meta_value, $prev_value = '') {
            return update_post_meta($post_id, $meta_key, $meta_value, $prev_value);
        });
        // https://developer.wordpress.org/reference/functions/wp_set_object_terms/
        $functions[] = ExpressionFunction::fromEvaluator('wp_set_object_terms', function ($args, $object_id, $terms, $taxonomy, $append = \false) {
            return wp_set_object_terms($object_id, $terms, $taxonomy, $append);
        });
        // https://developer.wordpress.org/reference/functions/get_term_by/
        $functions[] = ExpressionFunction::fromEvaluator('get_term_by', function ($args, $field, $value, $taxonomy = '', $output = OBJECT, $filter = 'raw') {
            return get_term_by($field, $value, $taxonomy, $output, $filter);
        });
        // https://developer.wordpress.org/reference/functions/wp_insert_term/
        $functions[] = ExpressionFunction::fromEvaluator('wp_insert_term', function ($elargs, $term, $taxonomy, $args = []) {
            return wp_insert_term($term, $taxonomy, $args);
        });
        // https://developer.wordpress.org/reference/functions/wp_hash/
        $functions[] = ExpressionFunction::fromEvaluator('wp_hash', function ($args, $data, $scheme = 'auth') {
            return wp_hash($data, $scheme);
        });
        // https://developer.wordpress.org/reference/functions/wp_salt/
        $functions[] = ExpressionFunction::fromEvaluator('wp_salt', function ($args, $scheme = 'auth') {
            return wp_salt($scheme);
        });
        // https://developer.wordpress.org/reference/functions/wp_generate_password/
        $functions[] = ExpressionFunction::fromEvaluator('wp_generate_password', function ($args, $length = 12, $special_chars = \true, $extra_special_chars = \false) {
            return wp_generate_password($length, $special_chars, $extra_special_chars);
        });
        // https://developer.wordpress.org/reference/functions/get_post_type/
        $functions[] = ExpressionFunction::fromEvaluator('get_post_type', function ($args, $post = null) {
            return get_post_type($post);
        });
        // https://developer.wordpress.org/reference/functions/get_post_types/
        $functions[] = ExpressionFunction::fromEvaluator('get_post_types', function ($args, $argsArr = [], $output = 'names', $operator = 'and') {
            return get_post_types($argsArr, $output, $operator);
        });
        // https://developer.wordpress.org/reference/functions/home_url/
        $functions[] = ExpressionFunction::fromEvaluator('home_url', function ($args, $path = '', $scheme = null) {
            return home_url($path, $scheme);
        });
        // https://developer.wordpress.org/reference/functions/get_queried_object/
        $functions[] = ExpressionFunction::fromEvaluator('get_queried_object', function ($args) {
            return get_queried_object();
        });
        // https://developer.wordpress.org/reference/functions/get_term_children/
        $functions[] = ExpressionFunction::fromEvaluator('get_term_children', function ($args, $term_id, $taxonomy) {
            return get_term_children($term_id, $taxonomy);
        });
        // https://developer.wordpress.org/reference/functions/get_plugins/
        $functions[] = ExpressionFunction::fromEvaluator('get_plugins', function ($args, $plugin_folder = '') {
            $func_name = 'get_plugins';
            if (!\function_exists($func_name)) {
                require_once 'wp-admin/includes/plugin.php';
            }
            return \call_user_func($func_name, $plugin_folder);
        });
        // https://developer.wordpress.org/reference/functions/get_site_transient/
        $functions[] = ExpressionFunction::fromEvaluator('get_site_transient', function ($args, $transient) {
            return get_site_transient($transient);
        });
        // https://developer.wordpress.org/reference/functions/delete_site_transient/
        $functions[] = ExpressionFunction::fromEvaluator('delete_site_transient', function ($args, $transient) {
            return delete_site_transient($transient);
        });
        // https://developer.wordpress.org/reference/functions/set_transient/
        $functions[] = ExpressionFunction::fromEvaluator('set_transient', function ($args, $transient, $value, $expiration = 0) {
            return set_transient($transient, $value, $expiration);
        });
        // https://developer.wordpress.org/reference/functions/get_page_by_path/
        $functions[] = ExpressionFunction::fromEvaluator('get_page_by_path', function ($args, $page_path, $output = OBJECT, $post_type = 'page') {
            return get_page_by_path($page_path, $output, $post_type);
        });
        // https://developer.wordpress.org/reference/functions/is_wp_error/
        $functions[] = ExpressionFunction::fromEvaluator('is_wp_error', function ($args, $thing) {
            return is_wp_error($thing);
        });
        $functions[] = ExpressionFunction::fromEvaluator('wp_call_user_func', function ($args, $callback, $parameter = []) {
            $callback = CorePackageDefinition::parseCallback($callback);
            $parameter = CorePackageDefinition::parseCallbackParameters($parameter);
            self::checkCallbackFunction($callback);
            if (\is_null($parameter) || \is_array($parameter) && empty($parameter)) {
                return \call_user_func($callback);
            }
            return \call_user_func($callback, ...$parameter);
        });
        $functions[] = ExpressionFunction::fromEvaluator('wp_call_user_func_array', function ($args, $callback, $parameter = []) {
            $callback = CorePackageDefinition::parseCallback($callback);
            $parameter = CorePackageDefinition::parseCallbackParameters($parameter);
            self::checkCallbackFunction($callback);
            return \call_user_func_array($callback, $parameter);
        });
        // https://developer.wordpress.org/reference/functions/sanitize_title/
        $functions[] = ExpressionFunction::fromEvaluator('sanitize_title', function ($args, $text) {
            return sanitize_title($text);
        });
        // https://developer.wordpress.org/reference/functions/apply_filters/
        $functions[] = ExpressionFunction::fromEvaluator('apply_filters', function ($elargs, $tag, $value, ...$args) {
            return apply_filters($tag, $value, ...$args);
        });
        // https://developer.wordpress.org/reference/functions/do_action/
        $functions[] = ExpressionFunction::fromEvaluator('do_action', function ($elargs, $tag, ...$args) {
            do_action($tag, ...$args);
        });
        // https://developer.wordpress.org/reference/functions/get_bloginfo/
        $functions[] = ExpressionFunction::fromEvaluator('get_bloginfo', function ($elargs, $show = '', $filter = 'raw') {
            return get_bloginfo($show, $filter);
        });
        // https://developer.wordpress.org/reference/functions/get_the_title/
        $functions[] = ExpressionFunction::fromEvaluator('get_post_title', function ($elargs, $post = null) {
            return get_the_title($post);
        });
        // https://developer.wordpress.org/reference/functions/get_post_field/
        $functions[] = ExpressionFunction::fromEvaluator('get_post_field', function ($elargs, $field, $post = null, $context = 'display') {
            return get_post_field($field, $post, $context);
        });
        // https://developer.wordpress.org/reference/functions/is_user_logged_in/
        $functions[] = ExpressionFunction::fromEvaluator('is_user_logged_in', function ($elargs) {
            return is_user_logged_in();
        });
        // https://developer.wordpress.org/reference/functions/wp_upload_dir/
        $functions[] = ExpressionFunction::fromEvaluator('wp_upload_dir', function ($elargs, $time = null, $create_dir = \true) {
            return wp_upload_dir($time, $create_dir);
        });
        // https://developer.wordpress.org/reference/functions/sanitize_text_field/
        $functions[] = ExpressionFunction::fromEvaluator('sanitize_text_field', function ($args, $text) {
            return sanitize_text_field($text);
        });
        return $functions;
    }
    public static function checkCallbackFunction($callback)
    {
        if (!\is_string($callback)) {
            return;
        }
        if (!\function_exists($callback)) {
            require_once ABSPATH . 'wp-admin/includes/media.php';
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/image.php';
            require_once ABSPATH . 'wp-admin/includes/update.php';
            require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        if (!\function_exists($callback)) {
            throw new \Exception('Function "' . $callback . '" does not exists.');
        }
    }
    protected function _initDefintions()
    {
        $CONTEXT_ID = ['editor_type' => 'context_id', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Source', 'description' => 'Referenced WP Query Context (id)', 'valueType' => 'string'];
        $PAGE_INFO = ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'page_info', 'name' => 'Page info var', 'description' => 'Variable name under which to provide search results page info', 'valueType' => 'string'];
        $POST_INFO = ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'post_info', 'name' => 'Post info var', 'description' => 'Variable name under which to provide current post info', 'valueType' => 'string'];
        return [new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpRestDoRequestElement', 'WP REST Do Request', 'Performs a WordPress REST API request and stores the result.', ['method' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'GET', 'name' => 'HTTP Method', 'description' => 'HTTP method for the request (GET, POST, etc).', 'valueType' => 'string'], 'route' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '/wp/v2/posts', 'name' => 'REST Route', 'description' => 'REST API route (e.g., /wp/v2/posts).', 'valueType' => 'string'], 'query_params' => ['editor_type' => 'params', 'editor_properties' => [], 'defaultValue' => [], 'name' => 'Query Parameters', 'description' => 'Query parameters to pass to the request.', 'valueType' => 'array'], 'body_params' => ['editor_type' => 'params', 'editor_properties' => [], 'defaultValue' => [], 'name' => 'Body Parameters', 'description' => 'Body parameters to pass to the request.', 'valueType' => 'array'], 'result_name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'wp_rest_result', 'name' => 'Result variable name', 'description' => 'Name of the variable to store the result in.', 'valueType' => 'string'], 'on_success' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Success', 'description' => 'Components to execute on successful request.', 'valueType' => 'class'], 'on_failure' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Failure', 'description' => 'Components to execute on failed request.', 'valueType' => 'class'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">WP REST API</span> request <b>{{ component.properties.method }}</b> to <b>{{ component.properties.route }}</b>' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-rest-do-request-element.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpRemoteRequestElement', 'WP Remote Request', 'Performs an external REST API request (over HTTP) and stores the result.', ['method' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'GET', 'name' => 'HTTP Method', 'description' => 'HTTP method for the request (GET, POST, etc).', 'valueType' => 'string'], 'url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'https://api.example.com/v1/posts', 'name' => 'Full URL', 'description' => 'Full URL for the external API (e.g., https://api.example.com/v1/posts).', 'valueType' => 'string'], 'query_params' => ['editor_type' => 'params', 'editor_properties' => [], 'defaultValue' => [], 'name' => 'Query Parameters', 'description' => 'Query parameters to pass to the request.', 'valueType' => 'array'], 'body_params' => ['editor_type' => 'params', 'editor_properties' => [], 'defaultValue' => [], 'name' => 'Body Parameters', 'description' => 'Body parameters to pass to the request.', 'valueType' => 'array'], 'headers' => ['editor_type' => 'params', 'editor_properties' => [], 'defaultValue' => [], 'name' => 'Headers', 'description' => 'HTTP headers (e.g., Authorization: Bearer token).', 'valueType' => 'array'], 'content_type' => ['editor_type' => 'select', 'editor_properties' => ['options' => ['application/json' => 'JSON', 'application/x-www-form-urlencoded' => 'Form Data']], 'defaultValue' => 'application/json', 'name' => 'Content Type', 'description' => 'Body content type (for POST/PUT).', 'valueType' => 'string'], 'timeout' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 30, 'name' => 'Timeout (seconds)', 'description' => 'Request timeout.', 'valueType' => 'integer'], 'result_name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'wp_rest_result', 'name' => 'Result variable name', 'description' => 'Name of the variable to store the result in.', 'valueType' => 'string'], 'on_success' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Success', 'description' => 'Components to execute on successful request.', 'valueType' => 'class'], 'on_failure' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Failure', 'description' => 'Components to execute on failed request.', 'valueType' => 'class'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">WP Remote REST API</span> request <b>{{ component.properties.method }}</b> to <b>{{ component.properties.url }}</b>' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-remote-request-element.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpQueryElement', 'WP Query Element', 'Allows simple access to the WP Query Context results', ['context_id' => $CONTEXT_ID, 'page_info_var' => $PAGE_INFO, 'has_results' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Has results', 'description' => 'Executed if there are results', 'valueType' => 'class'], 'no_results' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'No results', 'description' => 'Executed if there are no results', 'valueType' => 'class'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . 'WP_Query from <b>{{ component.properties.context_id }}</b>' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-query-element.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpDbElement', 'WP DB Element', 'Perform an operation directly on the WP Database', ['action' => ['editor_type' => 'select', 'editor_properties' => ['options' => ['select' => 'Select', 'insert' => 'Insert', 'update' => 'Update', 'delete' => 'Delete', 'replace' => 'Replace', 'query' => 'Custom query'], 'multiple' => \false], 'defaultValue' => 'select', 'name' => 'Action', 'description' => 'Which action to take on the table.', 'valueType' => 'string'], 'table_name' => ['editor_type' => 'text', 'editor_properties' => ['dependency' => 'component.properties.action !== "select" && component.properties.action !== "query"'], 'defaultValue' => null, 'name' => 'Table name', 'description' => 'Actual name of the table you wish to access', 'valueType' => 'string'], 'query' => ['editor_type' => 'desc', 'editor_properties' => ['dependency' => 'component.properties.action === "select" || component.properties.action === "query"'], 'defaultValue' => null, 'name' => 'Query', 'description' => 'Query to run', 'valueType' => 'string'], 'last_result_name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'last_result', 'name' => 'Last Result Name', 'description' => 'Name under which to store last query results in the service parameters.', 'valueType' => 'string'], 'insert_id_name' => ['editor_type' => 'text', 'editor_properties' => ['dependency' => 'component.properties.action === "insert" || component.properties.action === "replace"'], 'defaultValue' => 'insert_id', 'name' => 'Insert ID Name', 'description' => 'Name under which to store the auto incremented insert ID from the last Insert operation.', 'valueType' => 'string'], 'data' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true, 'dependency' => 'component.properties.action === "insert" || component.properties.action === "update" || component.properties.action === "replace"'], 'defaultValue' => null, 'name' => 'Data', 'description' => 'Key-value pairs of data you wish to insert, update, replace, etc.', 'valueType' => 'array'], 'format' => ['editor_type' => 'text', 'editor_properties' => ['dependency' => 'component.properties.action === "insert" || component.properties.action === "update" || component.properties.action === "replace"'], 'defaultValue' => null, 'name' => 'Formatting options', 'description' => 'For each data value, set corresponding formatting option. Use %s to format as string, %d as integer (whole number), and %f as float. Separate values with semicolon (;).', 'valueType' => 'string'], 'where' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true, 'dependency' => 'component.properties.action === "update" || component.properties.action === "delete" || component.properties.action === "replace"'], 'defaultValue' => null, 'name' => 'Where', 'description' => 'Key-value pairs of "where" confitions for replacing, deleting, etc.', 'valueType' => 'array'], 'where_format' => ['editor_type' => 'text', 'editor_properties' => ['dependency' => 'component.properties.action === "update" || component.properties.action === "delete" || component.properties.action === "replace"'], 'defaultValue' => null, 'name' => 'Where formatting options', 'description' => 'For each "where" value, set corresponding formatting option. Use %s to format as string, %d as integer (whole number), and %f as float. Separate values with semicolon (;).', 'valueType' => 'string'], 'ok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'OK', 'description' => 'Elements to be read if query succeeds', 'valueType' => 'class'], 'nok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'NOK', 'description' => 'Elements to be read if query fails', 'valueType' => 'class'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<p ng-if="component.properties.action !== \'select\' && component.properties.action !== \'query\'">' . '<b><span class="statement">PERFORM {{ component.properties.action.toUpperCase() }}</span></b> on table <b>{{ component.properties.table_name }}</b>' . '</p>' . '<span ng-if="component.properties.action === \'insert\'">' . '<span>{{ component.properties.action.toUpperCase() }} INTO {{ component.properties.table_name }} (<span ng-repeat="(key, obj) in component.properties.data">{{$last ? key : key + ", "}}</span>) <span>VALUES</span> (<span ng-repeat="(key, obj) in component.properties.data">{{$last ? obj : obj + ", "}}</span>)</span>' . '</span>' . '<span ng-if="component.properties.action === \'update\'">' . '<span>{{ component.properties.action.toUpperCase() }} {{ component.properties.table_name }} SET (<span ng-repeat="(key, obj) in component.properties.data">{{$last ? key + " = " + obj : key + " = " + obj  + ", "}}</span>) <span>WHERE</span> <span ng-repeat="(key, obj) in component.properties.where">{{$last ? key + " = " + obj : key + " = " + obj  + " AND "}}</span> </span>' . '</span>' . '<span ng-if="component.properties.action === \'delete\'">' . '<span>{{ component.properties.action.toUpperCase() }} FROM {{ component.properties.table_name }} WHERE <span ng-repeat="(key, obj) in component.properties.where">{{$last ? key + " = " + obj : key + " = " + obj  + " AND "}}</span></span>' . '</span>' . '<span ng-if="component.properties.action === \'replace\'">' . '<span>{{ component.properties.action.toUpperCase() }} INTO {{ component.properties.table_name }} (<span ng-repeat="(key, obj) in component.properties.data">{{$last ? key : key + ", "}}</span>) <span>VALUES</span> (<span ng-repeat="(key, obj) in component.properties.data">{{$last ? obj : obj + ", "}}</span>)</span>' . '</span>' . '<span ng-if="component.properties.action === \'select\' || component.properties.action === \'query\'">' . '<p ng-if="component.properties.action === \'select\'"><b><span class="statement">EXECUTE SELECT</code></b> on DB</p>' . '<p ng-if="component.properties.action === \'query\'"><b><span class="statement">EXECUTE QUERY</code></b> on DB</p>' . '<span ng-if="component.properties.query">{{ component.properties.query }}</span>' . '</span>' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-db-element.md'], '_factory' => new class($this->_wpdb) implements IComponentFactory
        {
            private $_wpdb;
            public function __construct($wpdb)
            {
                $this->_wpdb = $wpdb;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Wp\Pckg\WpCore\WpDbElement($properties, $this->_wpdb);
            }
        }]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpLoopElement', 'WP Loop Element', 'Allows simple looping over WP_Query results provided by the WP Query Context component (loop over single results page)', ['context_id' => $CONTEXT_ID, 'single_post_info_var' => $POST_INFO, 'each_post' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Each post', 'description' => 'Elements to be executed for each post from result', 'valueType' => 'class'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . 'Loop over <b>{{ component.properties.context_id }}</b> WP Query Context results' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-loop-element.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpLoopPageBlock', 'WP Loop Page Block', 'Loop over WP_Query results with a built in pagination and selection support', ['role' => ['defaultValue' => IRunnableBlock::ROLE_CONVERSATION_BLOCK], 'block_id' => ['editor_type' => 'block_id', 'editor_properties' => [], 'defaultValue' => 'new-block-id', 'name' => 'Block ID', 'description' => 'Unique string identificator', 'valueType' => 'string'], 'name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'Loop page block', 'name' => 'Block name', 'description' => 'A user friendly name for the block', 'valueType' => 'string'], 'context_id' => $CONTEXT_ID, 'page_info_var' => $PAGE_INFO, 'single_post_info_var' => $POST_INFO, 'elements' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Page info phase', 'description' => 'Initial elements to read upon results page change or landing to this step', 'valueType' => 'class'], 'each_post' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Each post', 'description' => 'Elements to be executed for each post on page', 'valueType' => 'class'], 'after_loop' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'After loop', 'description' => 'Elements to be executed after the posts loop is done', 'valueType' => 'class', '_separate' => \true], 'post_selected' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Post selected flow', 'description' => 'Elements to be executed when user selected post', 'valueType' => 'class'], 'processors' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationProcessor'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Process phase', 'description' => 'Other processors to be executed in process phase. E.g. help, repeat ... This procoessors will not trigger loop iteration.', 'valueType' => 'class'], 'no_selected' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Selected not avilable', 'description' => 'Elements to be read if selected post is not available (e.g. select 5th post but you have only 3 posts)', 'valueType' => 'class'], 'no_next' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Next not avilable', 'description' => 'Elements to be read if next page is requested but not available', 'valueType' => 'class'], 'no_previous' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Previous not avilable', 'description' => 'Elements to be read if previous page is requested but not available', 'valueType' => 'class'], 'fallback' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Fallback', 'description' => 'Elements to be read if none of the processors match', 'valueType' => 'class'], '_workflow' => 'read', '_system' => \true, '_factory' => new class($this->_packageProviderFactory) implements IComponentFactory
        {
            private $_packageProviderFactory;
            public function __construct(\Convo\Core\Factory\PackageProviderFactory $packageProviderFactory)
            {
                $this->_packageProviderFactory = $packageProviderFactory;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Wp\Pckg\WpCore\WpLoopPageBlock($properties, $service, $this->_packageProviderFactory);
            }
        }, '_help' => ['type' => 'file', 'filename' => 'wp-loop-page-block.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpLoopPostBlock', 'WP Loop Post Block', 'Selected post from the WP Loop Context', ['role' => ['defaultValue' => IRunnableBlock::ROLE_CONVERSATION_BLOCK], 'block_id' => ['editor_type' => 'block_id', 'editor_properties' => [], 'defaultValue' => 'new-block-id', 'name' => 'Block ID', 'description' => 'Unique string identificator', 'valueType' => 'string'], 'name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'New block', 'name' => 'Block name', 'description' => 'A user friendly name for the block', 'valueType' => 'string'], 'context_id' => $CONTEXT_ID, 'page_info_var' => $PAGE_INFO, 'single_post_info_var' => $POST_INFO, 'elements' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Read post', 'description' => 'Elements to read upon post selection change or initial landing to this step', 'valueType' => 'class', '_separate' => \true], 'processors' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationProcessor'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Process phase', 'description' => 'Other processors to be executed in process phase. E.g. help, repeat ... This procoessors will not trigger any loop iteration.', 'valueType' => 'class'], 'no_next' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Next not avilable', 'description' => 'Elements to be read if next post is requested but not available', 'valueType' => 'class'], 'no_previous' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Previous not avilable', 'description' => 'Elements to be read if previous post is requested but not available', 'valueType' => 'class'], 'fallback' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'Fallback', 'description' => 'Elements to be read if none of the processors match', 'valueType' => 'class'], '_workflow' => 'read', '_system' => \true, '_factory' => new class($this->_packageProviderFactory) implements IComponentFactory
        {
            private $_packageProviderFactory;
            public function __construct(\Convo\Core\Factory\PackageProviderFactory $packageProviderFactory)
            {
                $this->_packageProviderFactory = $packageProviderFactory;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Wp\Pckg\WpCore\WpLoopPostBlock($properties, $service, $this->_packageProviderFactory);
            }
        }, '_help' => ['type' => 'file', 'filename' => 'wp-loop-post-block.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpQueryContext', 'WP Query Context', 'Performs search with WP_Query and defined arguments', ['id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'search_posts', 'name' => 'Context ID', 'description' => 'Unique ID by which this context is referenced', 'valueType' => 'string'], 'args' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => ['post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => 3], 'name' => 'WP_Query args', 'description' => 'Arguments passed to the WP_Query object', 'valueType' => 'array'], 'resetNaviVar' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Rewind pagination', 'description' => 'Expression which if evaluated to true will rewind pagination to the first page', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">WP_Query </span> <b>[{{ contextElement.properties.id }}]</b>' . '</div>'], '_interface' => '\\Convo\\Core\\Workflow\\IServiceContext', '_workflow' => 'datasource', '_help' => ['type' => 'file', 'filename' => 'wp-query-context.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpMediaContext', 'WP_Query mp3 source', 'Performs WP_Query and exposes result as media player source', ['id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'search_media', 'name' => 'Context ID', 'description' => 'Unique ID by which this context is referenced', 'valueType' => 'string'], 'args' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => ['post_type' => 'attachment', 'post_mime_type' => 'audio/mpeg', 'post_status' => 'all', 'orderby' => 'title', 'order' => 'ASC'], 'name' => 'WP_Query args', 'description' => 'Arguments passed to the WP_Query object', 'valueType' => 'array'], 'song_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Song URL', 'description' => 'Optional expression to evaluate song URL. If empty, wp_get_attachment_url() is used.', 'valueType' => 'string'], 'song_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Song Title', 'description' => 'Optional expression to evaluate song title. If empty, meta title or post title will be used', 'valueType' => 'string'], 'artist' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Artist', 'description' => 'Optional expression to evaluate song artist. If empty, meta artist or meta album will be used', 'valueType' => 'string'], 'artwork_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Song image', 'description' => 'Song image URL. If empty, system will use get_the_post_thumbnail_url() or "Default song image" if thumbnail is empty too', 'valueType' => 'string'], 'background_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Background image', 'description' => 'Background image url. Can be expression which will be evaluated in the service context.', 'valueType' => 'string'], 'default_song_image_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Default song image', 'description' => 'Default image for song artwork. Can be expression which will be evaluated in the service context.', 'valueType' => 'string'], 'default_loop' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Default loop status', 'description' => 'Empty (false) or expression (boolean) to have initial player loop state', 'valueType' => 'string'], 'default_shuffle' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Default shuffle status', 'description' => 'Empty (false) or expression (boolean) to have initial player shuffle state', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">WP Media </span> <b>[{{ contextElement.properties.id }}]</b>' . '</div>'], '_interface' => '\\Convo\\Core\\Workflow\\IServiceContext', '_workflow' => 'datasource', '_help' => ['type' => 'file', 'filename' => 'wp-media-context.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpPostContext', 'Custom Post Catalog', 'Use a catalog list for custom posts', ['entity_name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Entity name', 'description' => 'Entity name to use with this catalog.', 'valueType' => 'string'], 'version' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Version', 'description' => 'A value or expression that will determine whether or not a new set of values should be published for this catalog.', 'valueType' => 'string'], 'query_params' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'Query parameters', 'description' => 'Query parameters used to filter WP posts.', 'valueType' => 'array'], 'final_value' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Final value', 'description' => 'An expression through which to format the final catalog value of any given post. Use WP functions such as get_the_title() etc. Result for each post MUST be a single string value.', 'valueType' => 'string'], 'class_aliases' => ['\\Convo\\Wp\\Pckg\\WpCore\\WpPostCatalog'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">FORMAT EACH POST TO FINAL VALUE<br><b>{{ contextElement.properties.final_value }}</b></span>' . '</div>'], '_workflow' => 'datasource', '_help' => ['type' => 'file', 'filename' => 'wp-post-context.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpTableContext', 'WP Custom Table Catalog', 'Query the WP Database on a table to create a catalog of values', ['entity_name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Entity name', 'description' => 'Entity name to use with this catalog.', 'valueType' => 'string'], 'version' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Version', 'description' => 'A value or expression that will determine whether or not a new set of values should be published for this catalog.', 'valueType' => 'string'], 'query' => ['editor_type' => 'ssml', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Query', 'description' => 'SQL query to run on the table.', 'valueType' => 'string'], 'final_value' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Final value', 'description' => 'An expression through which to format the final catalog value of any given query row. The expression will be evaluated for every row of the result, and you can access that row by using `row.property`. Result for each row MUST be a single string value.', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">FORMAT EACH VALUE TO<br><b>{{ contextElement.properties.final_value }}</b></span>' . '</div>'], '_workflow' => 'datasource', '_factory' => new class($this->_wpdb) implements IComponentFactory
        {
            private $_wpdb;
            public function __construct($wpdb)
            {
                $this->_wpdb = $wpdb;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Wp\Pckg\WpCore\WpTableContext($properties, $this->_wpdb);
            }
        }, '_help' => ['type' => 'file', 'filename' => 'wp-table-context.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\GetWpUserElement', 'Init current auth user', 'Initialize the currently authenticated user.', ['name' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'user', 'name' => 'Name', 'description' => 'Name under which to store the loaded user object in the context', 'valueType' => 'string'], 'should_set_as_current_user' => ['editor_type' => 'boolean', 'editor_properties' => [], 'defaultValue' => \true, 'name' => 'Set as Current User?', 'description' => 'Should change the current user by ID? Initially there is no WP User set in the service.', 'valueType' => 'boolean'], 'prompt_for_linking' => ['editor_type' => 'boolean', 'editor_properties' => [], 'defaultValue' => \false, 'name' => 'Prompt for linking', 'description' => 'Prompt the user to link their account if an authenticated user could not be loaded.', 'valueType' => 'boolean'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . 'Load user and set it as <span class="statement"><b>{{ component.properties.name }}</b></span>' . '</div>'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'get-wp-user-element.md'], '_factory' => new class($this->_adminUserDataProvider) implements IComponentFactory
        {
            private $_adminUserDataProvider;
            public function __construct(AdminUserDataProvider $adminUserDataProvider)
            {
                $this->_adminUserDataProvider = $adminUserDataProvider;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Wp\Pckg\WpCore\GetWpUserElement($properties, $this->_adminUserDataProvider);
            }
        }]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpInsertPostElement', 'WP Insert Post Element', 'Allows to insert or update WP Posts.', ['created_post_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Name', 'description' => 'Name under which to store the recently created post.', 'valueType' => 'string'], 'fire_after_hooks' => ['editor_type' => 'boolean', 'editor_properties' => [], 'defaultValue' => \true, 'name' => 'Fire After Hooks', 'description' => 'Whether to fire the after insert hooks. Default value: true', 'valueType' => 'boolean'], 'post_args' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => ['post_type' => 'post', 'post_title' => 'Hello World!', 'post_content' => '', 'post_status' => 'publish'], 'name' => 'WP Post args', 'description' => 'An array of elements that make up a post to update or insert.', 'valueType' => 'array'], 'post_tax_input' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'WP Post tax input', 'description' => 'Array of taxonomy terms keyed by their taxonomy name. Default empty.', 'valueType' => 'array'], 'post_meta_input' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'WP Post meta input', 'description' => 'Array of post meta values keyed by their post meta key. Default empty.', 'valueType' => 'array'], 'on_success' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Success', 'description' => 'Executed if the post was successfully inserted or updated.', 'valueType' => 'class'], 'on_failure' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Failure', 'description' => 'Executed if the post was not successfully inserted or updated.', 'valueType' => 'class'], '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'wp-insert-post-element.md']]), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpInsertUserElement', 'WP Insert User Element', 'Allows to insert WP Users.', ['created_user_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Name', 'description' => 'Name under which to store the recently created user.', 'valueType' => 'string'], 'username' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Username', 'description' => 'Username of the user to be created. (required)', 'valueType' => 'string'], 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user to be created. (recommended)', 'valueType' => 'string'], 'available_wp_roles' => ['editor_type' => 'select', 'editor_properties' => ['options' => wp_roles()->get_names()], 'defaultValue' => get_option('default_role'), 'name' => 'Role', 'description' => 'Role from available WP Roles for the user to be created.', 'valueType' => 'string'], 'user_meta_input' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'WP User meta input', 'description' => 'An array of elements that make up key value pairs for user meta to be inserted or updated.', 'valueType' => 'array'], 'on_user_exists' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On User Exists', 'description' => 'Executed if the user already exists.', 'valueType' => 'class'], 'on_success' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Success', 'description' => 'Executed if the user was successfully inserted.', 'valueType' => 'class'], 'on_failure' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Failure', 'description' => 'Executed if the user was not inserted successfully.', 'valueType' => 'class'], '_help' => ['type' => 'file', 'filename' => 'wp-insert-user-element.md'], '_workflow' => 'read']), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\WpUpdateUserMetaElement', 'WP Update User Meta Element', 'Allows to update meta of WP Users.', ['updated_user_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Status Var', 'description' => 'Name under which to store the recently updated user.', 'valueType' => 'string'], 'user_id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '0', 'name' => 'User ID', 'description' => 'ID of the user to be updated. (required)', 'valueType' => 'string'], 'user_meta_input' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'WP User meta input', 'description' => 'An array of elements that make up key value pairs for user meta to be inserted or updated.', 'valueType' => 'array'], 'on_success' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Success', 'description' => 'Executed if the user was found to update meta for.', 'valueType' => 'class'], 'on_failure' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'name' => 'On Failure', 'description' => 'Executed if the user was not found to update meta for.', 'valueType' => 'class'], '_help' => ['type' => 'file', 'filename' => 'wp-update-user-meta-element.md'], '_workflow' => 'read']), new ComponentDefinition($this->getNamespace(), '\\Convo\\Wp\\Pckg\\WpCore\\SimpleWpMailElement', 'WP Mail', 'Send email using wp_mail() function', ['to' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'To', 'description' => 'To who we are sending email', 'valueType' => 'string'], 'subject' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Subject', 'description' => 'Subject for the email', 'valueType' => 'string'], 'message' => ['editor_type' => 'desc', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Subject', 'description' => 'Email message', 'valueType' => 'string'], 'from' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'From', 'description' => 'Optional, from for the email', 'valueType' => 'string'], '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">SEND</span> wp_mail() <b>{{ component.properties.subject }}</b> <span class="statement">TO</span> <b>{{ component.properties.to }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'simple-wp-mail-element.md']])];
    }
}
