<?php

namespace Convo\Pckg\Visuals;

use Convo\Core\Factory\AbstractPackageDefinition;
class VisualsPackageDefinition extends AbstractPackageDefinition
{
    public const NAMESPACE = 'convo-visuals';
    public function __construct(\Psr\Log\LoggerInterface $logger)
    {
        parent::__construct($logger, self::NAMESPACE, __DIR__);
    }
    protected function _initDefintions()
    {
        return [new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Visuals\\Elements\\ListTitleElement', 'List Title', 'Initiates list layout and sets title and list type.', ['list_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'Title', 'name' => 'List title', 'description' => 'Title line for the list.', 'valueType' => 'string'], 'list_template' => ['editor_type' => 'select', 'editor_properties' => ['options' => ['LIST' => 'List', 'CAROUSEL' => 'Carousel']], 'defaultValue' => 'LIST', 'name' => 'List template', 'description' => 'Choose between Vertical or Horizontal list layout.', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="list-container">' . ' <div><span class="title-main">{{component.properties.list_title}}</span> [{{component.properties.list_template}}]</div>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'list-title-element.html'], '_workflow' => 'read', '_platform_defaults' => ['amazon' => ['interfaces' => ['ALEXA_PRESENTATION_APL']]]]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Visuals\\Elements\\ListItemElement', 'List Item', 'Defines the contents for a list item', ['list_item_key' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Key', 'description' => 'Unique key (index, id) of the item which is in the list.', 'valueType' => 'string'], 'list_item_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'Title', 'name' => 'Title', 'description' => 'Title for the list item', 'valueType' => 'string'], 'list_item_description_1' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'Description', 'name' => 'Description 1', 'description' => 'Description of the list item', 'valueType' => 'string'], 'list_item_description_2' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Description 2', 'description' => 'Secondary description of the list item (works with Alexa only)', 'valueType' => 'string'], 'list_item_image_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Image url', 'description' => 'URL for an image to be displayed', 'valueType' => 'string'], 'list_item_image_text' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Image text', 'description' => 'Accessibility text for the item image (Required if you want to display the image)', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="list-container">' . '<div class="list-item">' . '<div class="row">' . '<div class="col-md-2">' . '<div class="image-placeholder" ng-if="component.properties.list_item_image_url && component.properties.list_item_image_url.indexOf(\'http\') !== 0"><div>IMG</div></div>' . '<div class="image-placeholder" ng-if="component.properties.list_item_image_url && component.properties.list_item_image_url.indexOf(\'http\') === 0">' . '<img src="{{component.properties.list_item_image_url}}" alt="IMG">' . '</div>' . '</div>' . '<div class="col-md-10">' . '<div class="title">{{component.properties.list_item_title}}</div><div class="subtitle"> {{component.properties.list_item_description_2}}</div>' . '<div>{{component.properties.list_item_description_1}}</div>' . '</div>' . '</div>' . '</div>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'list-item-element.html'], '_workflow' => 'read', '_platform_defaults' => ['amazon' => ['interfaces' => ['ALEXA_PRESENTATION_APL']]]]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Visuals\\Elements\\ListElement', 'x!List', '*** DEPRECATED *** Iterates over a collection and renders a visual representation for each item in the list. (Works with devices that have the screen output capability.)', ['list_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List title', 'description' => 'Title of the content that is in the list.', 'valueType' => 'string'], 'list_template' => ['editor_type' => 'select', 'editor_properties' => ['options' => ['LIST' => 'List', 'CAROUSEL' => 'Carousel']], 'defaultValue' => 'LIST', 'name' => 'List template', 'description' => 'Choose between Vertical or Horizontal list layout.', 'valueType' => 'string'], 'data_collection' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Items', 'description' => 'Collection of items which will be displayed in the list as a visual representation of each list item.', 'valueType' => 'string'], 'offset' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Offset', 'description' => 'Display this many items from the beginning of the collection.', 'valueType' => 'string'], 'limit' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => null, 'name' => 'Limit', 'description' => 'Display to this many items of the collection.', 'valueType' => 'string'], 'list_item_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List item title', 'description' => 'Title of the item which is in the list.', 'valueType' => 'string'], 'list_item_description_1' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List item description 1', 'description' => 'Description of the item which is in the list.', 'valueType' => 'string'], 'list_item_description_2' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List item description 2', 'description' => 'Secondary description of the item which is in the list. (works with Alexa only)', 'valueType' => 'string'], 'list_item_image_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List item image url', 'description' => 'Link to the image of an item in the list.', 'valueType' => 'string'], 'list_item_image_text' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'List item image text', 'description' => 'Accessibility text of the image of an item in the list. (Required if you want to display the image.)', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<ul class="list-unstyled">' . ' <li>List name: {{component.properties.list_title}}</li>' . ' <li>List template: {{component.properties.list_template}}</li>' . ' <li>List items: {{component.properties.data_collection}}</li>' . ' <li>List item title: {{component.properties.list_item_title}}</li>' . ' <li>List item description 1: {{component.properties.list_item_description_1}}</li>' . ' <li>List item description 2: {{component.properties.list_item_description_2}}</li>' . ' <li>List item image URL: {{component.properties.list_item_image_url}}</li>' . ' <li>List item image text: {{component.properties.list_item_image_text}}</li>' . '</ul>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'list-element.html'], '_workflow' => 'read', '_platform_defaults' => ['amazon' => ['interfaces' => ['ALEXA_PRESENTATION_APL']]]]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Visuals\\Elements\\CardElement', 'Card', 'Display the properties of an object in a visual layout (Works with devices that have the screen output capability).', ['data_item_title' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'Title', 'name' => 'Title', 'description' => 'Title of the item which will be displayed on the card.', 'valueType' => 'string'], 'data_item_subtitle' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Subtitle', 'description' => 'Subtitle of the item which will be displayed on the card.', 'valueType' => 'string'], 'data_item_description_1' => ['editor_type' => 'desc', 'editor_properties' => [], 'defaultValue' => 'Description', 'name' => 'Description 1', 'description' => 'Primary description of the item which will be displayed on the card.', 'valueType' => 'string'], 'data_item_description_2' => ['editor_type' => 'desc', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Description 2', 'description' => 'Secondary description of the item which will be displayed on the card (works with Alexa only).', 'valueType' => 'string'], 'data_item_description_3' => ['editor_type' => 'desc', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Description 3', 'description' => 'Tertiary description of the item which will be displayed on the card (works with Alexa only).', 'valueType' => 'string'], 'data_item_image_url' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Image url', 'description' => 'Link to the image of an item in the card.', 'valueType' => 'string'], 'data_item_image_text' => ['editor_type' => 'text', 'editor_properties' => ['dependency' => 'component.properties.data_item_image_url && component.properties.data_item_image_url !== ""'], 'defaultValue' => '', 'name' => 'Image text', 'description' => 'Accessibility text of the image of an item in the card (Required if you want to display the image).', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="card-container">' . '<div class="row">' . '<div class="col-md-8">' . ' <div class="title-main">{{component.properties.data_item_title}}</div>' . ' <div><div class="subtitle">{{component.properties.data_item_subtitle}}</div></div>' . ' <div>{{component.properties.data_item_description_1}}</div>' . ' <div>{{component.properties.data_item_description_2}}</div>' . '</div>' . '<div class="col-md-4">' . '<div class="image-placeholder large" ng-if="component.properties.data_item_image_url && component.properties.data_item_image_url.indexOf(\'http\') !== 0"><div>IMG</div></div>' . '<div class="image-placeholder large" ng-if="component.properties.data_item_image_url && component.properties.data_item_image_url.indexOf(\'http\') === 0">' . '<img src={{component.properties.data_item_image_url}} alt="IMG">' . '</div>' . '</div>' . '</div>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'card-element.html'], '_workflow' => 'read', '_platform_defaults' => ['amazon' => ['interfaces' => ['ALEXA_PRESENTATION_APL']]]])];
    }
}
