<?php

namespace Convo\Pckg\Forms;

use Convo\Core\Workflow\IConversationElement;
use Convo\Core\Workflow\IConvoRequest;
use Convo\Core\Workflow\IConvoResponse;
use Convo\Core\Params\IServiceParamsScope;
class UpdateEntryElement extends \Convo\Pckg\Forms\AbstractFormsElement
{
    private $_entry_id;
    private $_entry = [];
    private $_resultVar;
    /**
     * @var IConversationElement[]
     */
    private $_ok = [];
    /**
     * @var IConversationElement[]
     */
    private $_validationError = [];
    /**
     * @param array $properties
     */
    public function __construct($properties)
    {
        parent::__construct($properties);
        $this->_entry_id = $properties['entry_id'];
        $this->_entry = $properties['entry'];
        $this->_resultVar = $properties['result_var'];
        foreach ($properties['ok'] as $element) {
            $this->_ok[] = $element;
            $this->addChild($element);
        }
        foreach ($properties['validation_error'] as $element) {
            $this->_validationError[] = $element;
            $this->addChild($element);
        }
    }
    public function read(IConvoRequest $request, IConvoResponse $response)
    {
        $context = $this->_getFormsContext();
        $entry_id = $this->evaluateString($this->_entry_id);
        $data = [];
        $params = $this->getService()->getComponentParams(IServiceParamsScope::SCOPE_TYPE_REQUEST, $this);
        $this->_logger->info('Updating entry with id [' . $entry_id . ']');
        $entry = $this->getService()->evaluateArgs($this->_entry, $this);
        try {
            $data['previous'] = $context->getEntry($entry_id);
            $context->updateEntry($entry_id, $entry);
            $data['updated'] = $context->getEntry($entry_id);
            $elements = $this->_ok;
        } catch (\Convo\Pckg\Forms\FormValidationException $e) {
            $this->_logger->info($e->getMessage());
            $data['message'] = $e->getMessage();
            $data['errors'] = $e->getResult()->getErrors();
            $elements = $this->_validationError;
        }
        $this->_logger->info('Updated entry with id [' . $entry_id . ']');
        $params->setServiceParam($this->_resultVar, $data);
        foreach ($elements as $elem) {
            $elem->read($request, $response);
        }
    }
    // UTIL
    public function __toString()
    {
        return parent::__toString();
    }
}
