<?php

declare (strict_types=1);
namespace Convo\Pckg\Appointments;

use Convo\Core\Adapters\Alexa\Api\AlexaSettingsApi;
use Convo\Core\Factory\AbstractPackageDefinition;
use Convo\Core\Factory\IComponentFactory;
class AppointmentsPackageDefinition extends AbstractPackageDefinition
{
    public const NAMESPACE = 'convo-appointments';
    /**
     * @var AlexaSettingsApi
     */
    private $_alexaSettingsApi;
    public function __construct(\Psr\Log\LoggerInterface $logger, AlexaSettingsApi $alexaSettingsApi)
    {
        $this->_alexaSettingsApi = $alexaSettingsApi;
        parent::__construct($logger, self::NAMESPACE, __DIR__);
        // $this->addTemplate($this->_loadFile(__DIR__ . '/schedule-appointments.template.json'));
    }
    protected function _initDefintions()
    {
        $context_id_param = ['editor_type' => 'context_id', 'editor_properties' => [], 'defaultValue' => 'your_appointment', 'name' => 'Context ID', 'description' => 'Unique ID by which this context is referenced', 'valueType' => 'string'];
        $timezone_mode_param = ['editor_type' => 'select', 'editor_properties' => ['options' => [\Convo\Pckg\Appointments\AbstractAppointmentElement::TIMEZONE_MODE_DEFAULT => 'Default', \Convo\Pckg\Appointments\AbstractAppointmentElement::TIMEZONE_MODE_CLIENT => 'Client', \Convo\Pckg\Appointments\AbstractAppointmentElement::TIMEZONE_MODE_SET => 'Set']], 'defaultValue' => \Convo\Pckg\Appointments\AbstractAppointmentElement::TIMEZONE_MODE_DEFAULT, 'name' => 'Timezone Mode', 'description' => 'By default you will use timezone provided by context. Client will try to get client\'s timezone, while set will allow you to set it manualy', 'valueType' => 'string'];
        $timezone_param = ['editor_type' => 'text', 'editor_properties' => ['dependency' => "component.properties.timezone_mode === '" . \Convo\Pckg\Appointments\AbstractAppointmentElement::TIMEZONE_MODE_SET . "'"], 'defaultValue' => '', 'name' => 'Timezone', 'description' => 'Enabled only when timezone mode is on "Set". Enter explicit timezone value.', 'valueType' => 'string'];
        return [new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\CheckAppointmentTimeElement', 'Check Appointment Time Element', 'Checks if the time for an appointment is available.', ['context_id' => $context_id_param, 'appointment_date' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Date', 'description' => 'Date of the appointment.', 'valueType' => 'string'], 'appointment_time' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Time', 'description' => 'Time of the appointment.', 'valueType' => 'string'], 'result_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Result Variable Name', 'description' => 'Status variable of the result from appointment checking.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'suggestions_builder' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Pckg\\Appointments\\Freeslot\\IFreeSlotQueueFactory'], 'multiple' => \false], 'defaultValue' => null, 'defaultOpen' => \false, 'name' => 'Suggestion Builder', 'description' => 'Suggestion builder to build up suggestions', 'valueType' => 'class'], 'available_flow' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Available', 'description' => 'Flow to be executed if the requested appointment date is available.', 'valueType' => 'class'], 'suggestions_flow' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Suggestions', 'description' => 'Flow to be executed if the requested appointment date is available.', 'valueType' => 'class'], 'single_suggestion_flow' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true, 'hideWhenEmpty' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Single Suggestion', 'description' => 'Flow to be executed if the requested appointment date is available.', 'valueType' => 'class'], 'no_suggestions_flow' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true, 'hideWhenEmpty' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'No Suggestions', 'description' => 'Flow to be executed if the requested appointment date is available.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\CheckAppointmentTimeElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">CHECK TIME</span> <b>{{ component.properties.appointment_date }} {{ component.properties.appointment_time }}</b> <span class="statement">IN</span> <b>{{ component.properties.context_id }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'check-appointment-time-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\DefaultFreeSlotQueue', 'Default free slot collector', 'Collects and generates free slots suggestions', ['max_suggestions' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '${5}', 'name' => 'Max Suggestions', 'description' => 'How many suggestions to return. Use 0 if your system does not supports suggestions', 'valueType' => 'string'], '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">BUILD FREE SLOTS</span> <b>{{ component.properties.max_suggestions }}</b> <span class="statement">SUGGESTIONS</span>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'default-free-slot-queue.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\SimpleFreeSlotGenerator', 'List free slots', 'Collects all available free slots.', ['max_suggestions' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '${50}', 'name' => 'Max Suggestions', 'description' => 'How many slots to return. Use 0 if your system does not support free slot listings.', 'valueType' => 'string'], '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">LIST</span> <b>{{ component.properties.max_suggestions }}</b> <span class="statement">FREE SLOTS</span>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'simple-free-slot-generator.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\LoadAppointmentElement', 'Load Appointment Element', 'Loads the details of an appointment for the user.', ['context_id' => $context_id_param, 'appointment_id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment ID', 'description' => 'Appointment ID to load the appointment details from', 'valueType' => 'string'], 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user to load the appointment details from.', 'valueType' => 'string'], 'return_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Return Variable Name', 'description' => 'Status variable of the loaded appointment.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'ok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'OK', 'description' => 'Flow to be executed if the appointment under ID was found.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\LoadAppointmentElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">LOAD APPOINTMENT</span> <b>{{ component.properties.context_id }}</b> <b>{{ component.properties.appointment_id }}</b> <span class="statement">FOR</span> <b>{{ component.properties.email }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'load-appointment-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\LoadAppointmentsElement', 'Load Appointments Element', 'Loads appointments for the user.', ['context_id' => $context_id_param, 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user to load the appointment for.', 'valueType' => 'string'], 'mode' => ['editor_type' => 'select', 'editor_properties' => ['options' => [\Convo\Pckg\Appointments\IAppointmentsContext::LOAD_MODE_ALL => 'All', \Convo\Pckg\Appointments\IAppointmentsContext::LOAD_MODE_CURRENT => 'Current', \Convo\Pckg\Appointments\IAppointmentsContext::LOAD_MODE_PAST => 'Past']], 'defaultValue' => \Convo\Pckg\Appointments\IAppointmentsContext::LOAD_MODE_CURRENT, 'name' => 'Mode', 'description' => 'Loads appointments which are currently active, already finished or both.', 'valueType' => 'string'], 'limit' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 10, 'name' => 'Number of Appointments to Load', 'description' => 'Appointment ID to load the appointment details from.', 'valueType' => 'string'], 'return_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Return Variable Name', 'description' => 'Status variable of the loaded appointment.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'multiple' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Multiple', 'description' => 'Flow to be executed if more than one appointments could be found.', 'valueType' => 'class'], 'single' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true, 'hideWhenEmpty' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Single', 'description' => 'Flow to be executed if one appointment could be found.', 'valueType' => 'class'], 'empty' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true, 'hideWhenEmpty' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Empty', 'description' => 'Flow to be executed if no appointment could be found.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\LoadAppointmentsElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">LOAD APPOINTMENTS</span> <b>{{ component.properties.mode }}</b> <b>{{ component.properties.context_id }}</b> <span class="statement">FOR</span> <b>{{ component.properties.email }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'load-appointments-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\CreateAppointmentElement', 'Create Appointment Element', 'Creates an appointment for the user.', ['context_id' => $context_id_param, 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user to create the appointment for.', 'valueType' => 'string'], 'appointment_date' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Date', 'description' => 'Date of the appointment.', 'valueType' => 'string'], 'appointment_time' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Time', 'description' => 'Time of the appointment.', 'valueType' => 'string'], 'payload' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'Payload', 'description' => 'An array of elements that fills the Additional appointment data such as customer info, appointment notes and etc.', 'valueType' => 'array'], 'result_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Result Variable Name', 'description' => 'Status variable of the result of appointment creation.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'ok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'OK', 'description' => 'Flow to be executed if the appointment could be created.', 'valueType' => 'class'], 'not_available' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Not Available', 'description' => 'Flow to be executed if the appointment could not be created.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\CreateAppointmentElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">CREATE APPOINTMENT</span> <b>{{ component.properties.context_id }}</b> <span class="statement">FOR</span> <b>{{ component.properties.email }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'create-appointment-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\UpdateAppointmentElement', 'Update Appointment Element', 'Updates an appointment for the user.', ['context_id' => $context_id_param, 'appointment_id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment ID', 'description' => 'ID of the appointment to perform the update.', 'valueType' => 'string'], 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user which has the appointment.', 'valueType' => 'string'], 'appointment_date' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Date', 'description' => 'Date of the appointment.', 'valueType' => 'string'], 'appointment_time' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment Time', 'description' => 'Time of the appointment.', 'valueType' => 'string'], 'payload' => ['editor_type' => 'params', 'editor_properties' => ['multiple' => \true], 'defaultValue' => [], 'name' => 'Payload', 'description' => 'An array of elements that fills the Additional appointment data such as customer info, appointment notes and etc.', 'valueType' => 'array'], 'result_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Result Variable Name', 'description' => 'Status variable of the result of appointment update.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'ok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'OK', 'description' => 'Flow to be executed if the appointment could be updated.', 'valueType' => 'class'], 'not_available' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'Not available', 'description' => 'Flow to be executed if the appointment date is not available for the specified time slot.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\UpdateAppointmentElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">UPDATE APPOINTMENT</span> <b>{{ component.properties.context_id }}</b> <b>{{ component.properties.appointment_id }}</b> <span class="statement">FOR</span> <b>{{ component.properties.email }}</b> ' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'update-appointment-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\CancelAppointmentElement', 'Cancel Appointment Element', 'Cancels an appointment for the user.', ['context_id' => $context_id_param, 'appointment_id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Appointment ID', 'description' => 'ID of the appointment to cancel.', 'valueType' => 'string'], 'email' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => '', 'name' => 'Email', 'description' => 'Email of the user to cancel the appointment.', 'valueType' => 'string'], 'result_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Result Variable Name', 'description' => 'Status variable of the result of appointment update.', 'valueType' => 'string'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, 'ok' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \false, 'name' => 'OK', 'description' => 'Flow to be executed if the appointment was canceled successfully.', 'valueType' => 'class'], '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\CancelAppointmentElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">CANCEL APPOINTMENT</span> <b>{{ component.properties.context_id }}</b> <b>{{ component.properties.appointment_id }}</b> <span class="statement">FOR</span> <b>{{ component.properties.email }}</b>' . '</div>'], '_help' => ['type' => 'file', 'filename' => 'cancel-appointment-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\TimezoneWrapperElement', 'Timezone Wrapper Element', 'Executes elements in the provided timezone mode.', ['context_id' => $context_id_param, 'result_var' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'status', 'name' => 'Result Variable Name', 'description' => 'Status variable that contains timezone (string) information. E.g. ${status.timezone}', 'valueType' => 'string'], 'elements' => ['editor_type' => 'service_components', 'editor_properties' => ['allow_interfaces' => ['\\Convo\\Core\\Workflow\\IConversationElement'], 'multiple' => \true], 'defaultValue' => [], 'defaultOpen' => \true, 'name' => 'Elements', 'description' => 'Elements to be executed', 'valueType' => 'class'], 'timezone_mode' => $timezone_mode_param, 'timezone' => $timezone_param, '_factory' => new class($this->_alexaSettingsApi) implements IComponentFactory
        {
            private $_alexaSettingsApi;
            public function __construct($alexaCustomerProfileApi)
            {
                $this->_alexaSettingsApi = $alexaCustomerProfileApi;
            }
            public function createComponent($properties, $service)
            {
                return new \Convo\Pckg\Appointments\TimezoneWrapperElement($properties, $this->_alexaSettingsApi);
            }
        }, '_workflow' => 'read', '_help' => ['type' => 'file', 'filename' => 'timezone-wrapper-element.md']]), new \Convo\Core\Factory\ComponentDefinition($this->getNamespace(), '\\Convo\\Pckg\\Appointments\\DummyAppointmentsContext', 'Dummy Appointments Context', 'Provides dummy, test implementation of the appointment managing context', ['id' => ['editor_type' => 'text', 'editor_properties' => [], 'defaultValue' => 'appointments_ctx', 'name' => 'Context ID', 'description' => 'Unique ID by which this context is referenced', 'valueType' => 'string'], '_preview_angular' => ['type' => 'html', 'template' => '<div class="code">' . '<span class="statement">DUMMY APPOINTMENTS CONTEXT </span> <b>[{{ contextElement.properties.id }}]</b>' . '</div>'], '_workflow' => 'datasource', '_help' => ['type' => 'file', 'filename' => 'dummy-appointments-context.md']])];
    }
}
