<?php

declare (strict_types=1);
namespace Convo\Core\Preview;

/**
 * @deprecated This interface will be removed in a future version.
 */
class PreviewSection
{
    private $_name;
    /**
     * @var PreviewUtterance[]
     */
    private $_utterances = [];
    public function __construct($name)
    {
        $this->_name = $name;
    }
    public function isEmpty()
    {
        return \count($this->_utterances) === 0;
    }
    public function collect($elements, $interface)
    {
        foreach ($elements as $element) {
            $speech = [];
            $this->_populateSpeech($speech, $element, $interface);
            foreach ($speech as $part) {
                if ($interface === '\\Convo\\Core\\Preview\\IBotSpeechResource') {
                    $this->_addUtterance(new \Convo\Core\Preview\PreviewUtterance($part->getSpeech()->getText()));
                } elseif ($interface === '\\Convo\\Core\\Preview\\IUserSpeechResource') {
                    $this->_addUtterance(new \Convo\Core\Preview\PreviewUtterance($part->getText(), \false, $part->getIntentSource()));
                } else {
                    throw new \Exception('Unknown speech resource interface [' . $interface . ']');
                }
            }
        }
    }
    public function collectOne($element, $interface)
    {
        $speech = [];
        $this->_populateSpeech($speech, $element, $interface);
        foreach ($speech as $part) {
            if ($interface === '\\Convo\\Core\\Preview\\IBotSpeechResource') {
                $this->_addUtterance(new \Convo\Core\Preview\PreviewUtterance($part->getSpeech()->getText()));
            } elseif ($interface === '\\Convo\\Core\\Preview\\IUserSpeechResource') {
                $this->_addUtterance(new \Convo\Core\Preview\PreviewUtterance($part->getSpeech()->getText(), \false, $part->getSpeech()->getIntentSource()));
            } else {
                throw new \Exception('Unknown speech resource interface [' . $interface . ']');
            }
        }
    }
    public function getData()
    {
        return ['name' => $this->_name, 'utterances' => \array_map(function ($utterance) {
            return $utterance->getData();
        }, $this->_utterances)];
    }
    private function _addUtterance(\Convo\Core\Preview\PreviewUtterance $utterance)
    {
        $this->_utterances[] = $utterance;
    }
    private function _populateSpeech(&$array, $element, $interface)
    {
        // being a speech resource takes precedence over being a container component.
        if (\is_a($element, $interface)) {
            $array[] = $element;
        } elseif (\is_a($element, '\\Convo\\Core\\Workflow\\IWorkflowContainerComponent')) {
            /** @var \Convo\Core\Workflow\IWorkflowContainerComponent $element */
            $this->_flattenWorkflowContainers($array, $element, $interface);
        }
    }
    private function _flattenWorkflowContainers(&$array, $element, $interface)
    {
        $array = \array_merge($array, $element->findChildren($interface));
        if (($index = \array_search($element, $array)) !== \false) {
            \array_splice($array, $index, 1);
        }
        foreach ($array as $item) {
            if (\is_a($item, '\\Convo\\Core\\Workflow\\IWorkflowContainerComponent')) {
                $this->_flattenWorkflowContainers($array, $item, $interface);
            }
        }
    }
}
