<?php

declare (strict_types=1);
namespace Convo\Core\Admin;

use Convo\Core\Rest\RequestInfo;
use Convo\Core\Util\SimpleFileResource;
class MediaRestHandler implements \Psr\Http\Server\RequestHandlerInterface
{
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $_logger;
    /**
     * @var \Convo\Core\Util\IHttpFactory
     */
    private $_httpFactory;
    /**
     * @var \Convo\Core\Media\IServiceMediaManager
     */
    private $_mediaService;
    public function __construct($logger, $httpFactory, $mediaService)
    {
        $this->_logger = $logger;
        $this->_httpFactory = $httpFactory;
        $this->_mediaService = $mediaService;
    }
    public function handle(\Psr\Http\Message\ServerRequestInterface $request) : \Psr\Http\Message\ResponseInterface
    {
        $info = new RequestInfo($request);
        if ($info->post() && ($route = $info->route('media/{serviceId}'))) {
            return $this->_handleMediaPathServiceIdPost($request, $route->get('serviceId'));
        }
        if ($info->get() && ($route = $info->route('media/{serviceId}/{mediaItemId}/download'))) {
            return $this->_handleMediaPathServiceIdPathMediaItemIdPathDownloadGet($request, $route->get('serviceId'), $route->get('mediaItemId'));
        }
        throw new \Convo\Core\Rest\NotFoundException('Could not map info [' . $info . ']');
    }
    private function _handleMediaPathServiceIdPost(\Psr\Http\Message\ServerRequestInterface $request, $serviceId)
    {
        /** @var \Psr\Http\Message\UploadedFileInterface[] $files */
        $files = $request->getUploadedFiles();
        $response = [];
        foreach ($files as $filename => $image) {
            $this->_logger->debug("Handling file [{$filename}]");
            $file = new SimpleFileResource($image->getClientFilename(), $image->getClientMediaType(), $image->getStream()->__toString());
            $mediaItemId = $this->_mediaService->saveMediaItem($serviceId, $file);
            \array_push($response, ['mediaItemId' => $mediaItemId, 'imageWidth' => \getimagesizefromstring($file->getContent())[0], 'imageHeight' => \getimagesizefromstring($file->getContent())[1], 'type' => $image->getClientMediaType()]);
        }
        return $this->_httpFactory->buildResponse($response);
    }
    private function _handleMediaPathServiceIdPathMediaItemIdPathDownloadGet(\Psr\Http\Message\ServerRequestInterface $request, $serviceId, $mediaItemId)
    {
        $meta = $this->_mediaService->getMediaInfo($serviceId, $mediaItemId);
        $image = $this->_mediaService->getMediaItem($serviceId, $mediaItemId);
        $this->_logger->info('Got item [' . $mediaItemId . '][' . $meta['mime_type'] . '][' . $meta['size'] . ']');
        return $this->_httpFactory->buildResponse($image->getContent(), 200, ['Content-Type' => $meta['mime_type'], 'Content-Length' => $meta['size']]);
    }
    // UTIL
    public function __toString()
    {
        return \get_class($this) . '[]';
    }
}
